<?php
defined('BASEPATH') or exit('No direct script access allowed');
$id = $this->db->get('tbl_user')->row_array();
$sess  = $this->session->userdata('no_pendaftaran');
$user   = $this->siswa->base_biodata($sess);
$v_materi = $this->siswa->get_print('materi');
$nilai_siswa  = $this->siswa->nilairapot('nilai-rapot', $sess);
$nilai      = $this->admin->nilai($sess);
?>

<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8">
  <title><?php echo $user->no_pendaftaran . ' - ' . $user->nama_lengkap; ?></title>
  <base href="<?php echo base_url(); ?>" />
  <link rel="icon" href="<?php echo base_url() . 'img/' . $id['logo']; ?>">
  <style>
    p {
      font-family: Arial, Helvetica, sans-serif;
      margin-top: 0;
      font-size: 10px;
    }

    .linetdtop {
      border-top: 1px solid #000;
      border-left: 1px solid #000;
      border-right: 1px solid #000;
    }

    .linetdbottom {
      border-bottom: 1px solid #000;
      border-left: 1px solid #000;
      border-right: 1px solid #000;
    }

    table {
      border-collapse: collapse;
    }

    thead>tr {
      background-color: #0070C0;
      color: #f1f1f1;
    }

    thead>tr>th {
      background-color: #0070C0;
      color: #fff;
      padding: 10px;
      border-color: #fff;
    }

    th,
    td {
      padding: 0px 4px;
      font-size: 12px;
    }

    th {
      color: #222;
    }

    body {
      font-family: -apple-system, 'Abel', BlinkMacSystemFont, 'Segoe UI', Oxygen, Ubuntu, Cantarell, 'Open Sans', 'Helvetica Neue', sans-serif;
    }
  </style>
</head>

<body>
  <p align="center">Tanda Bukti Verifikasi Akun <b><?php echo $user->no_pendaftaran; ?></b> | <?php echo $user->nama_lengkap; ?></p>
  <br>
  <!-- header logo -->
  <table width="100%" border="0">
    <tr>
      <td width="6%">
        <img src="<?php echo base_url() . 'img/' . $id['logo']; ?>" alt="logo" width="40" style="margin-top: -10px;">
      </td>
      <td width="50%">
        <p>PENERIMAAN PESERTA DIDIK BARU</p>
        <h4 style="margin-top: -12px; margin-bottom: -1px;"><?php echo $id['nama_lengkap']; ?></h4>
        <p><?php echo $id['alamat']; ?></p>
      </td>
      <td width="40%">
        <p align="right">
          Dokumen ini adalah <b>bukti sah verifikasi berkas</b><br>dikeluarkan oleh <?php echo $id['nama_lengkap']; ?> <br> melalui <?php echo base_url(); ?>
        </p>
      </td>
    </tr>
  </table>
  <!-- pendaftaran -->
  <table width="100%" border="1">
    <tr>
      <td width="90%">
        <p style="margin: 5px 0;">
          <strong>TANDA BUKTI VERIFIKASI<br>
            PENERIMAAN PESERTA DIDIK BARU</strong><br>
          Tahun Pelajaran <?php echo $id['th_pelajaran']; ?>
        </p>
      </td>
      <td align="center" rowspan="2"><img src="img/qrcode/imagedir/<?php echo $user->qrcode; ?>" alt="logo" width="40"></td>
    </tr>
    <tr>
      <td><b>INFO VERIFIKASI</b></td>
    </tr>
  </table>
  <table width="100%" border="1">
    <tr align="center">
      <td width="40%">Nomor Pendaftaran</td>
      <td width="20%">Jalur Masuk</td>
      <td width="40%">Tanggal Pendaftaran</td>
      <td width="20%">Status</td>
    </tr>
    <tr align="center">
      <td><b><?php echo $user->no_pendaftaran; ?></b></td>
      <td><b><?php echo $user->komp_ahli; ?></b></td>
      <td><b><?php echo $user->tgl_siswa; ?></b></td>
      <td><b style="color: green;">
          <?php if ($user->status_verifikasi == 1) { ?>
            Lulus Berkas
          <?php } elseif ($user->status_verifikasi == 2) { ?>
            Tidak Lulus Berkas
          <?php } else { ?>
            Belum diverifikasi
          <?php } ?>
        </b>
      </td>
    </tr>
    <tr>
      <td colspan="4"><b>BIODATA SISWA</b></td>
    </tr>
  </table>
  <!-- biodata -->
  <table width="100%" border="1">
    <tr>
      <td rowspan="6" width="10%" align="center">
        <?php if ($user->file_foto != NULL) { ?>
          <img src="upload/foto/<?php echo $user->file_foto; ?>" alt="pas foto" width="84">
        <?php } else {
          echo "<img src='upload/foto/default.png' alt='foto' width='60'>";
        } ?>
      </td>
      <td width="20%">Nomor Peserta</td>
      <td width="35%"><strong style="color: green;"><?php echo $user->nis; ?></strong></td>
      <td width="20%">1. Akte Kelahiran</td>
      <td width="10%">
        <?php if ($user->file_akte == NULL) { ?>
          belum
        <?php } else { ?>
          ada
        <?php } ?>
      </td>
    </tr>
    <tr>
      <td>NISN</td>
      <td><?php echo $user->nisn; ?></td>
      <td>2. Suket. Aktif Terakhir</td>
      <td>
        <?php if ($user->file_ijazah == NULL) { ?>
          belum
        <?php } else { ?>
          ada
        <?php } ?>
      </td>
    </tr>
    <tr>
      <td>Nama Lengkap</td>
      <td><?php echo strtoupper($user->nama_lengkap); ?></td>
      <td>3. Sertifikat Akreditasi</td>
      <td>
        <?php if ($user->file_kk == NULL) { ?>
          belum
        <?php } else { ?>
          ada
        <?php } ?>
      </td>
    </tr>
    <tr>
      <td>Jenis Kelamin</td>
      <td><?php echo $user->jk; ?></td>
      <td>4. Rapot</td>
      <td>
        <?php if ($user->file_rapot == NULL) { ?>
          belum
        <?php } else { ?>
          ada
        <?php } ?>
      </td>
    </tr>
    <tr>
      <td>Tempat & Tgl. Lahir</td>
      <td><?php echo "$user->tempat_lahir, " . $this->lib_data->tgl_id($user->tgl_lahir); ?></td>
      <td>5. Sertifikat Prestasi</td>
      <td>
        <?php if ($user->file_prestasi == NULL) { ?>
          belum
        <?php } else { ?>
          ada
        <?php } ?>
      </td>
    </tr>
    <tr>
      <td>Sekolah Asal</td>
      <td><?php echo ucwords($user->nama_sekolah); ?></td>
      <td>6. Suket. Tahfidz</td>
      <td>
        <?php if ($user->file_lain == NULL) { ?>
          belum
        <?php } else { ?>
          ada
        <?php } ?>
      </td>
    </tr>
    <tr>
      <td align="center">Pas Foto</td>
      <td>Alamat</td>
      <td colspan="3"><?php echo $user->alamat_siswa . ', Desa/Kelurahan ' . $user->desa . ', Kecamatan ' . $user->kec . ', Kabupaten ' . $user->kab . ', Provinsi ' . $user->prov . ' ' . $user->kode_pos; ?></td>
    </tr>
  </table>
  <!-- nilai -->
  <table width="100%" border="1" style="margin-top: 10px;">
    <tr>
      <td colspan=" 9"><b>DATA NILAI SISWA</b></td>
    </tr>
    <tr style="background-color: lightgray; font-weight: bold;">
      <td align="center">No</td>
      <td>Semester</td>
      <td align="center">AGM</td>
      <td align="center">MTK</td>
      <td align="center">BING</td>
      <td align="center">BINDO</td>
      <td align="center">IPA</td>
      <td align="center">IPS</td>
      <td align="center">TOTAL</td>
    </tr>
    <?php
    $no = 1;
    foreach ($nilai_siswa->result() as $baris) {
    ?>
      <tr>
        <td align="center"><?php echo $no++ . '.'; ?></td>
        <td><?php echo 'semester ' . $baris->nilairapot_sem; ?></td>
        <td align="center"><?php echo $baris->nilairapot_agm; ?></td>
        <td align="center"><?php echo $baris->nilairapot_mtk; ?></td>
        <td align="center"><?php echo $baris->nilairapot_bing; ?></td>
        <td align="center"><?php echo $baris->nilairapot_bindo; ?></td>
        <td align="center"><?php echo $baris->nilairapot_ipa; ?></td>
        <td align="center"><?php echo $baris->nilairapot_ips; ?></td>
        <td align="center"><b><?php echo $baris->nilairapot_rt; ?></b></td>
      </tr>
    <?php } ?>
    <tr class="text-bold bg-danger-300">
      <td colspan="2" align="center"><b>Rata-rata</b></td>
      <td align="center"><b><?php echo round($nilai->avg_agm); ?></b></td>
      <td align="center"><b><?php echo round($nilai->avg_mtk); ?></b></td>
      <td align="center"><b><?php echo round($nilai->avg_bing); ?></b></td>
      <td align="center"><b><?php echo round($nilai->avg_bindo); ?></b></td>
      <td align="center"><b><?php echo round($nilai->avg_ipa); ?></b></td>
      <td align="center"><b><?php echo round($nilai->avg_ips); ?></b></td>
      <td align="center"><b><?php echo round($nilai->avg_rt); ?></b></td>
    </tr>
  </table>
  <!-- keterangan -->
  <table width="100%" border="1" style="margin-top: 10px;">
    <tr align="center">
      <th width="80%" style="padding: 5px;">MATERI DAN JADWAL UJIAN</th>
      <th width="20%" style="padding: 5px;">CATATAN VERIFIKASI</th>
    </tr>
    <tr>
      <td style="padding: 10px;"><?php echo $v_materi->isi; ?></td>
      <td style="padding: 10px;" align="top"><?php echo $user->ctt_verifikasi; ?> </td>
    </tr>
    <tr>
      <td colspan="2">
        <p style="margin-top: 2px; margin-bottom: 4;">
          <b>PERINGATAN!</b> Calon siswa yang diterima namun <b>TIDAK DAFTAR ULANG</b> sesui dengan jadwal yang ditentukan, dianggap <b>MENGUNDULKAN DIRI</b>.
        </p>
      </td>
    </tr>
  </table>
  <!-- ttd -->
  <table width="100%" border="0" style="margin-top: 10px;">
    <tr>
      <td width="10%" class="linetdtop">
        <p>**Harap ditulis dengan nama terang dibawah tanda tangan.</p>
      </td>
      <td width="30%" valign="top" class="linetdtop">a/n <b><?php echo $user->nama_lengkap; ?></b><br>Menyetujui data diatas,<br><b>Ortu / Wali Siswa terdaftar</b> **)</td>
      <td width="30%" valign="top" class="linetdtop">Menyetujui data di atas,<br><b>Siswa terdaftar</b></td>
      <td width="30%" valign="top" class="linetdtop"><?php echo $id['kab_sekolah']; ?>,...................<?php echo date('Y') ?><br><b>Panitia PPDB</b></td>
    </tr>
    <tr>
      <td class="linetdbottom" style="padding: 30px 0;"></td>
      <td align="left" class="linetdbottom"> (................................................) </td>
      <td align="left" class="linetdbottom"> <?php echo $user->nama_lengkap; ?></td>
      <td align="left" class="linetdbottom"> <?php echo $id['ketua_panitia']; ?> </td>
    </tr>
  </table>
  <p align="center" style="margin-top: 10px;">
    Panitia Penerimaan Peserta Didik Baru (PPDB) | <b><?php echo $id['nama_lengkap']; ?></b><br>Tahun Pelajaran <?php echo $id['th_pelajaran']; ?>
  </p><br>
</body>

</html>